package gov.va.caret.service.ctssh.template;

import java.io.File;
import java.util.ArrayList;

import org.w3c.dom.NodeList;

import gov.va.caret.service.ctssh.util.AppHelper;





public final class ChainedTemplate extends Template {

    /*
    <CTSSH_Template key  =" * this is the key that will be used to uniquely identify this template * "  
                    type =" * this can be CHAIN, SIMPLE, or blank.  If it's blank it defaults to SIMPLE *"> 
    
      	<call_steps count="*">  the number of steps in the sequence
                * each step, in sequence, with their respective fail messages *;
		<step sequence="1" template_id="MVI.1305.ATTENDED.SEARCH" fail_message="Call to MVI 1305 Search has failed"/>
		<step sequence="2" template_id="VIA.LOGIN" 		fail_message="Login to VIA has failed"/>
		<step sequence="3" template_id="VIA.WRITE.TIU.NOTE" fail_message="Writing Note To VIA has failed"/>
		<step sequence="4" template_id="VIA.CLOSE.TIU.NOTE" fail_message="Closing Note In VIA has failed"/>
	</call_steps>

    
    </CTSSH_Template>
    */


   /**
 * 
 */
private ChainStep[] call_steps;
   /**
 * 
 */
private  ChainedTemplateRequestParameter[] _request_parameters;
   /**
 * 
 */
private  ArrayList<String> _parameter_names;
    
    /**
     * @param template
     * @throws Exception
     */
    protected ChainedTemplate(File template) throws Exception
    {
        super(template);
  
        
        AppHelper.log("Creating Chained Call Template : " + _key + " from " + template_path);
        
        //------------------------
        // LOAD THE REQUEST
        //------------------------
        
        //load up the request parameters
        _parameter_names = new ArrayList<>();
        NodeList nl_parameters = AppHelper.getNodeList(TEMPLATE_REQ_PARAMETER_XPATHKEY,template_doc);
        _request_parameters = new ChainedTemplateRequestParameter[nl_parameters.getLength()];
        for(int ix = 0; ix < nl_parameters.getLength(); ix++)
        {
            _request_parameters[ix] = new ChainedTemplateRequestParameter(nl_parameters.item(ix));
            _parameter_names.add(_request_parameters[ix].name().toLowerCase());
        }        
        
        NodeList nlSteps = AppHelper.getNodeList(TEMPLATE_CALL_STEPS, template_doc);
        
        call_steps = new ChainStep[nlSteps.getLength()];
        for(int ix = 0; ix < nlSteps.getLength(); ix++)
        {
            ChainStep cs = new ChainStep(nlSteps.item(ix));
            call_steps[cs.sequence() - 1] = cs;
        }
        
       
    }
 
    /**
     * @return
     */
    public ChainStep[] call_steps()
    {
        return call_steps;
    }

    
    /**
     * @param name
     * @return
     */
    public boolean isParameter(String name)
    {
        return _parameter_names.contains(name);
    }
 
    
}
